<?php

namespace App\Http\Controllers;

use App\Exceptions\BalaghatException;
use App\Http\Requests\ReportTypeRequest;
use App\Http\Traits\Api_Trait;
use App\Models\ReportType;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class ReportTypeController extends Controller
{
    use Api_Trait;

    public function index()
    {
        $types = ReportType::select('id', 'name')->get();
        return $this->returnData($types, __('messages.report_types'), 200);
    }
    public function store(ReportTypeRequest $request)
    {
        $type = ReportType::create($request->all());
        return $this->returnData($type, __('messages.report_type_created'), 200);
    }

    public function show(ReportType $reportType)
    {
        return $this->returnData($reportType, __('messages.report_type'), 200);
    }

    public function update(ReportTypeRequest $request, ReportType $reportType)
    {
        $reportType->update($request->all());

        return $this->returnData($reportType, __('messages.report_type_updated'), 200);
    }

    public function destroy(ReportType $reportType)
    {

        $hasReports = $reportType->reports()->exists();

        if ($hasReports) {
            return response()->json([
                'message' => __('messages.report_type_in_use')
            ], Response::HTTP_CONFLICT); // 409 Conflict
        }

        $reportType->delete();

        return $this->returnSuccessMessage(__('messages.report_type_deleted')); 
    }
}
