<?php

namespace App\Http\Requests;

class AttachmentRequest extends BaseFormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            // 'files' => 'required|array',
            'files.*' => 'required|file|mimes:xlsx,xls,jpg,jpeg,png,pdf,mp3,mp4,wav|max:20480',
        ];
    }
    public function attributes(): array
    {
        return [
            'files' => 'الملفات المرفقة',
        ];
    }
}
