<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProcedureReportRequest extends BaseFormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    public function store()
    {
        return [
            'procedure_id' => ['required', 'exists:procedures,id'],
            'notes' => ['nullable', 'string'],
        ];
    }
    public function update()
    {
        return [
            'procedure_id' => ['required', 'exists:procedures,id'],
            'notes' => ['nullable', 'string', 'max:191'],
        ];
    }
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules()
    {
        if ($this->isMethod('POST')) {
            return $this->store();
        }
        if ($this->isMethod('PUT')) {
            return $this->update();
        }
    }
}
