<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreReportRequest extends BaseFormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'report_type_id' => 'required|exists:report_types,id',
            'description' => 'required|string',
            'location' => 'nullable|string',
            'll' => 'nullable',
            'lg' => 'nullable',
            'attachment_ids' => 'nullable|array',
            'attachment_ids.*' => 'exists:attachments,id',
        ];
    }
    public function attributes(): array
    {
        return [
            'report_type_id' => 'نوع البلاغ',
            'description' => 'نص البلاغ',
            'location' => 'الموقع',
            'll' => 'خط العرض',
            'lg' => 'خط الطول',
            'attachment_id' => 'رقم الملف',
        ];
    }
}
