<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'national_id',
        'phone',
        'otp',
        'otp_expires_at',
        'is_admin',
    ];

    protected $hidden = ['otp'];

    protected $dates = ['otp_expires_at'];

    public function reports()
    {
        return $this->hasMany(Report::class);
    }
    public function attachments()
{
    return $this->morphMany(Attachment::class, 'uploaded_by');
}

}
