<?php

namespace Database\Seeders;

use App\Models\Procedure;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Schema;

class ProcedureSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $procedures =
            [
                [
                    'name' => 'تحويل الي الجهة المختصة',
                    'description' => 'تحويل الي الجهة المختصة',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'name' => 'جاري التحقيق',
                    'description' => 'جاري التحقيق',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'name' => 'تم إتخاذ الإجراء المطلوب',
                    'description' => 'تم إتخاذ الإجراء المطلوب',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
                [
                    'name' => 'مرفوضة مع سبب',
                    'description' => 'مرفوضة مع سبب',
                    'created_at' => now(),
                    'updated_at' => now(),
                ],
            ];

        Schema::disableForeignKeyConstraints();
        Procedure::truncate();
        Schema::enableForeignKeyConstraints();

        $chunked_procedures = array_chunk($procedures, 5);


        foreach ($chunked_procedures as $value) {
            Procedure::insert($value);
        }
    }
}
