
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `attachment_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachment_report` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `report_id` bigint unsigned NOT NULL,
  `attachment_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attachment_report_report_id_foreign` (`report_id`),
  KEY `attachment_report_attachment_id_foreign` (`attachment_id`),
  CONSTRAINT `attachment_report_attachment_id_foreign` FOREIGN KEY (`attachment_id`) REFERENCES `attachments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `attachment_report_report_id_foreign` FOREIGN KEY (`report_id`) REFERENCES `reports` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attachment_report` WRITE;
/*!40000 ALTER TABLE `attachment_report` DISABLE KEYS */;
INSERT INTO `attachment_report` VALUES (1,12,20,NULL,NULL),(2,12,21,NULL,NULL),(3,14,34,NULL,NULL),(4,14,35,NULL,NULL),(5,14,33,NULL,NULL);
/*!40000 ALTER TABLE `attachment_report` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `attachments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `original_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attachments` WRITE;
/*!40000 ALTER TABLE `attachments` DISABLE KEYS */;
INSERT INTO `attachments` VALUES (1,'reports/QqZc7Jdti4UKG7mTIY4MpWaxErjX1NTVGVtuRsY5.mp3','file_example_MP3_700KB.mp3','audio/mpeg','2025-05-28 12:30:36','2025-05-28 12:30:36'),(2,'reports/ZDtklF4i9D87irpOfiibAfcJe26FWi2ch6tBtR7S.pdf','National Eye API Documentation.pdf','application/pdf','2025-05-28 12:35:12','2025-05-28 12:35:12'),(3,'reports/f4FlEs7jsHrlCpzhCHAQA17i4gQDQ33wu86FtHoQ.pdf','National Eye API Documentation.pdf','application/pdf','2025-05-28 12:47:40','2025-05-28 12:47:40'),(4,'reports/T41esMCsS2qP7bibct23FkjUlFpwN1ZbzUXILtBK.mp3','file_example_MP3_700KB.mp3','audio/mpeg','2025-05-28 14:19:53','2025-05-28 14:19:53'),(5,'reports/Rw4xwy9Ao6WyWe5rtyfpaCbwbIQjz4bkPLuKjeBH.mp3','file_example_MP3_700KB.mp3','audio/mpeg','2025-05-28 14:35:40','2025-05-28 14:35:40'),(6,'reports/LPHVZ3LDq0vDWaBn0e14o3ht7WoIXNmvFnZNgIJs.jpg','738f4cd41dbaf814679d759272655715b4b4a19d.jpg','image/jpeg','2025-05-28 16:12:55','2025-05-28 16:12:55'),(7,'reports/adRvMnoKDoOeRagm0nqlElBi74tLPbDeHfVUQ1iN.jpg','00205f5e-fe37-48af-9d91-ba462161a8614182305316244100637.jpg','application/octet-stream','2025-05-28 18:12:12','2025-05-28 18:12:12'),(8,'attachments/tBY6kvkgHGrJp7T2z7Gi3joRCt2fppCJwVfm8YFg.jpg','Capture_827047513.JPG','image/jpeg','2025-06-01 11:46:37','2025-06-01 11:46:37'),(9,'attachments/XS6wtZHLO929oYZVd8u4kKbzXIgALAuq2fonNSAu.xlsx','Managers Report.xlsx','application/vnd.openxmlformats-officedocument.spreadsheetml.sheet','2025-06-01 11:46:37','2025-06-01 11:46:37'),(10,'attachments/xLpaUDqKpSWT57CFAOlRgCndLE7XN14FPs25NChx.jpg','738f4cd41dbaf814679d759272655715b4b4a19d.jpg','image/jpeg','2025-06-01 11:50:57','2025-06-01 11:50:57'),(11,'attachments/OS3QK5Q3GKotyrYnijP29vak60hnPCTsQLAXZBls.jpg','738f4cd41dbaf814679d759272655715b4b4a19d.jpg','image/jpeg','2025-06-01 11:55:54','2025-06-01 11:55:54'),(12,'attachments/xYG1Zf6ay3RBheauVbOBaGT5AoYRrdLz2NRZaKv1.jpg','738f4cd41dbaf814679d759272655715b4b4a19d.jpg','image/jpeg','2025-06-01 15:05:06','2025-06-01 15:05:06'),(13,'attachments/FSYMt6Fl6pTGQUomhya1HRaNdpdmSYcOUrx9uDzc.mp4','01-06-25-03-06-162584547715952200836.m4a','application/octet-stream','2025-06-01 15:06:23','2025-06-01 15:06:23'),(14,'attachments/fVlt6m5ooQ3mdWnZ2jqstrhFOat9Ln1rG2UcfpHE.jpg','1000053899.jpg','application/octet-stream','2025-06-01 15:06:36','2025-06-01 15:06:36'),(15,'attachments/7M6M2LLnrw5fYosELfvx8T5mARf0HhD2zuAjHI4X.mp4','01-06-25-03-17-028239947639874235824.m4a','application/octet-stream','2025-06-01 15:17:12','2025-06-01 15:17:12'),(16,'attachments/dUtgxA8lrKcayYu1NUnQPr0aGBYrIk95NaNSIaDF.mp4','01-06-25-03-45-22416257438842853501.m4a','application/octet-stream','2025-06-01 15:45:32','2025-06-01 15:45:32'),(17,'attachments/ZiUUaYMhjDpqULceqouTUajyVVaLFfBr3ijEZVTE.mp4','01-06-25-03-55-157215403222239256181.m4a','application/octet-stream','2025-06-01 15:55:23','2025-06-01 15:55:23'),(18,'attachments/k5Z6Hhf7CZREVgd6dPf9qHYbWFl4VFgfPhKaj53N.jpg','738f4cd41dbaf814679d759272655715b4b4a19d.jpg','application/octet-stream','2025-06-01 16:15:26','2025-06-01 16:15:26'),(19,'attachments/pUcFqUi76JNZEkNWhyDiMgdzR1WCPFFSVyFmxl28.jpg','17dae2a8-5ea4-41d3-9a7a-cd03784545f84610954354922365182.jpg','application/octet-stream','2025-06-01 16:15:33','2025-06-01 16:15:33'),(20,'attachments/gS37N4z5k0vBkCRdffjB5vli5LIxNpTtpQMtA9Hf.jpg','601d9c92-7c1e-4e0b-9a7b-3ed8f6fc85ec3212905601407679206.jpg','application/octet-stream','2025-06-01 16:18:08','2025-06-01 16:18:08'),(21,'attachments/TvyBWKSKhNCVGokHB76YeT4evoDhgg6LDc3hDauE.mp4','01-06-25-04-18-093604732282759269026.m4a','application/octet-stream','2025-06-01 16:18:14','2025-06-01 16:18:14'),(22,'attachments/IWcLzOxoLB8F9pbgL7uc8wwtF3eOg3fLVTVxoRb9.mp4','02-06-25-04-21-431653800563908176846.m4a','application/octet-stream','2025-06-02 15:22:02','2025-06-02 15:22:02'),(23,'attachments/Rlll6OHYUUsxjoObZwhFl6Ya2VlxMCSLo4jH1cmF.mp4','02-06-25-04-31-548386402498987871563.m4a','application/octet-stream','2025-06-02 15:32:21','2025-06-02 15:32:21'),(24,'attachments/7x0fxKRg8XzYCB0DRI4NBCGziq5rkIzLe3izKfBS.mp4','02-06-25-03-38-401669166048014554329.m4a','application/octet-stream','2025-06-02 15:38:48','2025-06-02 15:38:48'),(25,'attachments/zvuBN4CZmNMyi6YEZXQqshfTeeEvnIw34i0YSPYO.mp4','02-06-25-03-44-355797854705267671550.m4a','application/octet-stream','2025-06-02 15:44:43','2025-06-02 15:44:43'),(26,'attachments/PTU4FyAOgMu9Vq5W9jSzvGtuI4dCbzycJdqEBXPv.mp4','02-06-25-03-48-285270739084933653141.m4a','application/octet-stream','2025-06-02 15:48:34','2025-06-02 15:48:34'),(27,'attachments/wU5HkeE4IClw6KHALnA8MV6S9rzEwBR1qFvmbpuX.mp4','02-06-25-03-51-202540291775987499010.m4a','application/octet-stream','2025-06-02 15:51:27','2025-06-02 15:51:27'),(28,'attachments/lPPcwk1UJcn0Zh6qb4YIjJjv4zDZkagsGJrWOlEi.mp4','02-06-25-03-52-563678353541029086157.m4a','application/octet-stream','2025-06-02 15:53:03','2025-06-02 15:53:03'),(29,'attachments/sjFwQZgDtaWjg7K2cJj3T1JYCBTB6o8rG20NOmwu.mp4','02-06-25-04-00-12658670875697818055.m4a','application/octet-stream','2025-06-02 16:00:20','2025-06-02 16:00:20'),(30,'attachments/OyxsMmuOabj5sMjnUEETWyfe34w5vWpFzjcg8GrT.mp4','02-06-25-04-00-488197568704653468059.m4a','application/octet-stream','2025-06-02 16:00:54','2025-06-02 16:00:54'),(31,'attachments/ImABAsWOSl6KO6yniYOJ2f8qPLoIHe9TWnGIayGD.mp4','02-06-25-04-01-08506151767839871444.m4a','application/octet-stream','2025-06-02 16:01:15','2025-06-02 16:01:15'),(32,'attachments/LgAyaTSiLCUWRVteufy3gtrx7gq7jSsfEHUkXueP.jpg','1000053899.jpg','application/octet-stream','2025-06-02 16:03:58','2025-06-02 16:03:58'),(33,'attachments/9bIIAcvtZfsGzNNKwfSpcdgIYUOGweTdw08TmfXi.mp4','02-06-25-04-17-268462865137709110050.m4a','application/octet-stream','2025-06-02 16:17:35','2025-06-02 16:17:35'),(34,'attachments/aLYYMzdAOa7AmcX7YyLSrvQe16YO20YEpBndDI4C.jpg','9186914b-20a1-4c35-9d9f-1fd77bc880e67968119790795027269.jpg','application/octet-stream','2025-06-02 16:22:29','2025-06-02 16:22:29'),(35,'attachments/GDtMbEY2WMilSOLWfAXerkPNPWX2Ak83qlW3l51q.jpg','24982b90-afe8-4235-bb59-a17cf3e1ab55632941649878429411.jpg','application/octet-stream','2025-06-02 16:26:19','2025-06-02 16:26:19');
/*!40000 ALTER TABLE `attachments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_teams` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_teams_name_unique` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_teams` WRITE;
/*!40000 ALTER TABLE `employee_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_teams` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `employees` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT '0',
  `employee_team_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employees_email_unique` (`email`),
  KEY `employees_employee_team_id_foreign` (`employee_team_id`),
  CONSTRAINT `employees_employee_team_id_foreign` FOREIGN KEY (`employee_team_id`) REFERENCES `employee_teams` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employees` WRITE;
/*!40000 ALTER TABLE `employees` DISABLE KEYS */;
INSERT INTO `employees` VALUES (1,'Super Admin','admin@gmail.com','$2y$12$xRloH.YtmPCGqTlqejQQHOzwtWxKcAwJD.kqm1C95YhYNVOpNVy3e','01157861819','Test',1,NULL,'2025-05-27 12:53:38','2025-05-27 12:53:38'),(2,'nada','gnada1221@gmail.com','$2y$12$6Gy/uQ0jlajDtT1J6sC/refrNLr5uLAIc.nXBe1KeU86LlC77iRES',NULL,NULL,0,NULL,'2025-05-28 19:13:09','2025-05-28 19:13:09'),(4,'test2','test2@gmail.com','$2y$12$cbhg0Ru2eXVSqv8Y2q/EY.iHvOBVE/syaCw48dx1r7ySMGMm644Qi',NULL,NULL,1,NULL,'2025-05-28 19:23:05','2025-05-28 20:01:04'),(5,'test','test@gmail.com','$2y$12$9YCa/M9FrhMPeiVn6POSPut/EMbF5H2x.pRrJgynxP44fvf5dx5/.',NULL,NULL,0,NULL,'2025-05-28 20:11:59','2025-05-28 20:11:59'),(6,'qqqq','test211@gmail.com','$2y$12$RhhiNdO/wFEoZm1GeOUAhe1NIvcVibyPnTWOS.ZtYHn310gEPBCUS',NULL,NULL,0,NULL,'2025-05-28 20:16:41','2025-05-28 20:16:41'),(7,'qqqq','test21221@gmail.com','$2y$12$mfdhLAkwPblYVi69Kpadb.8zMwe7Jx/7QbXoFMX.l9YunfxfEu5h6',NULL,NULL,0,NULL,'2025-05-28 20:16:58','2025-05-28 20:16:58'),(8,'qqqq','test212s21@gmail.com','$2y$12$JDjLqNWwsCGCi59m6AAvH.t/gsMmdkXyreJmTWiOuW9odyID1Ew2C',NULL,NULL,0,NULL,'2025-05-28 20:17:07','2025-05-28 20:17:07'),(9,'qqqq','tes12s21@gmail.com','$2y$12$Azgjt4QDCiY7uBMVoe.CXezAA86Ni8p3Ree/gS8oUYeXcEGZDh8qi',NULL,NULL,0,NULL,'2025-05-28 20:17:19','2025-05-28 20:17:19'),(10,'qqqq','tes12sns21@gmail.com','$2y$12$Nmn69P6upSIgXhcWkrn3H.9ZrLdPMgZHNxqjpWirZyFwgQZgtP6i2',NULL,NULL,0,NULL,'2025-05-28 20:17:26','2025-05-28 20:17:26'),(12,'qqqq','tes12111@gmail.com','$2y$12$bR.HJ.z3vazM8aR47sCwCedOURDeFwQ9mqhpvd8POXJuG5GAd0HfO',NULL,NULL,0,NULL,'2025-05-28 20:17:40','2025-05-28 20:17:40'),(13,'qqqq','tes1a22111@gmail.com','$2y$12$Rk6mYgeva64RTqNdq/IB9OguAHSTax9s.6Afg5J/RLZdRjGJYVK1O',NULL,NULL,0,NULL,'2025-05-28 20:17:45','2025-05-28 20:17:45'),(14,'qqqq','teqa22111@gmail.com','$2y$12$PWjyg/Wb.94icMYE7mf4jeVW715d6/eEFHTgUCSDnlBNO.5ZIeMaK',NULL,NULL,0,NULL,'2025-05-28 20:17:57','2025-05-28 20:17:57'),(15,'qqqq','teqa22ll111@gmail.com','$2y$12$mtpmMYZXqfD020P9H.x3fee61f7BIAfmhGd.JPYUmDcFR4n.9t3Ti',NULL,NULL,0,NULL,'2025-05-28 20:18:02','2025-05-28 20:18:02');
/*!40000 ALTER TABLE `employees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_reset_tokens_table',1),(3,'2019_08_19_000000_create_failed_jobs_table',1),(4,'2019_12_14_000001_create_personal_access_tokens_table',1),(5,'2025_05_19_100423_create_report_types_table',1),(6,'2025_05_19_100425_create_reports_table',1),(7,'2025_05_22_112606_create_procedures_table',1),(8,'2025_05_22_113215_add_is_admin_to_users_table',1),(9,'2025_05_22_122336_create_procedure_report_table',1),(10,'2025_05_26_122821_create_employee_teams_table',2),(11,'2025_05_27_092513_create_employees_table',2),(12,'2025_05_27_095908_remove_is_admin_in_users_table',2),(13,'2025_05_27_121619_add_procedure_id_in_reports_table',2),(14,'2025_05_28_114630_create_attachments_table',3),(15,'2025_05_28_115355_add_attachment_id_in_reports_table',3),(16,'2025_05_28_190911_create_attachment_report_table',4),(17,'2025_06_03_141603_add_employee_id_in_prcedure_report_table',5);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
INSERT INTO `personal_access_tokens` VALUES (2,'App\\Models\\User',2,'api-token','072a9c8f2a9df8d208245411f69bb28d3b8016f80b7f52204752989177faff11','[\"*\"]',NULL,NULL,'2025-05-25 19:46:56','2025-05-25 19:46:56'),(3,'App\\Models\\User',3,'api-token','1e3272d03a31c0faaaf41968a0c9bb25a8f53ac13f4c89e1bb93287679c29a10','[\"*\"]',NULL,NULL,'2025-05-25 20:09:09','2025-05-25 20:09:09'),(4,'App\\Models\\User',3,'api-token','c3484faafa9b498ad6f541af02bafed503a38e4b9f72a48e372a60ce94164e86','[\"*\"]','2025-05-25 23:30:42',NULL,'2025-05-25 20:24:28','2025-05-25 23:30:42'),(5,'App\\Models\\User',1,'api-token','98897362d6628929fa9e9693bc354f85093c2fb241426fae15a6f44e0eb822bb','[\"*\"]','2025-05-25 23:30:47',NULL,'2025-05-25 20:26:54','2025-05-25 23:30:47'),(6,'App\\Models\\User',2,'api-token','2ef145f9b541088cd5bfa0ea565bd018534fa0a915be683a8c07f7b39f1591be','[\"*\"]','2025-05-25 20:46:35',NULL,'2025-05-25 20:41:03','2025-05-25 20:46:35'),(7,'App\\Models\\User',3,'api-token','76dff55623221d3000ab3ed6da2ebbcc76b2cfc59c168ffe84a164a00b8f1a9a','[\"*\"]','2025-05-28 12:33:04',NULL,'2025-05-28 10:31:40','2025-05-28 12:33:04'),(8,'App\\Models\\User',1,'api-token','a7421b279fbf386fa722afb7395c8378b72f51db85f8986cc8a8babd2092b49d','[\"*\"]','2025-06-02 15:37:57',NULL,'2025-05-28 11:01:43','2025-06-02 15:37:57'),(9,'App\\Models\\User',3,'api-token','81dce3e005ce3405f2ebfade5b25be79a9b3a6621fb99ac295361eadf4c36d74','[\"*\"]',NULL,NULL,'2025-05-28 11:26:16','2025-05-28 11:26:16'),(10,'App\\Models\\User',3,'api-token','54b2d221ae02dfd57b786e08e969024397cd0e63d50cf12d46a7401bc2e7f157','[\"*\"]',NULL,NULL,'2025-05-28 12:17:08','2025-05-28 12:17:08'),(11,'App\\Models\\User',6,'api-token','614195d88fe13284e8f310b122c5df82dd86c1edd3653f376ae006abf804c8cf','[\"*\"]','2025-06-02 16:11:08',NULL,'2025-05-28 12:44:15','2025-06-02 16:11:08'),(12,'App\\Models\\User',6,'api-token','36f60c02432b5747ccef4ccc0597c6f5bf84a7c4c8faad691ff42c057ac31ce1','[\"*\"]',NULL,NULL,'2025-05-28 13:00:47','2025-05-28 13:00:47'),(13,'App\\Models\\Employee',1,'employee-token','63439fc7244055b7a960a1285529a495407511986788e54d345acff6f7bf5a07','[\"*\"]',NULL,NULL,'2025-05-28 13:34:57','2025-05-28 13:34:57'),(14,'App\\Models\\Employee',1,'employee-token','519ee07934746ce83538b1afd309124971e18ce0bccf631cbc936bf6759221f6','[\"*\"]',NULL,NULL,'2025-05-28 13:45:12','2025-05-28 13:45:12'),(15,'App\\Models\\Employee',1,'employee-token','8e35a829852ad3b30b09dc785118ad02b5309141f22fded642d67a23174b620e','[\"*\"]',NULL,NULL,'2025-05-28 13:47:35','2025-05-28 13:47:35'),(16,'App\\Models\\Employee',1,'employee-token','69d548eb89577938a420e2582f60e2ef8a616d574663d4ce7971072c71dc2b4d','[\"*\"]',NULL,NULL,'2025-05-28 13:52:47','2025-05-28 13:52:47'),(17,'App\\Models\\Employee',1,'employee-token','120bc41a4625340ab444b79b78edf2b88896b898a88e230f51ff1ffd92d5eeda','[\"*\"]',NULL,NULL,'2025-05-28 14:24:36','2025-05-28 14:24:36'),(18,'App\\Models\\User',6,'api-token','ac018d89a85ca96ef9751768b8ef9a0995fff3a69929f92c6ac0e9302f0ba5d3','[\"*\"]',NULL,NULL,'2025-05-28 14:37:04','2025-05-28 14:37:04'),(19,'App\\Models\\Employee',1,'employee-token','bf5314cdc41f93fbbe78194dbf3d86de95788817150e54962ae3b2a23eeae3c6','[\"*\"]',NULL,NULL,'2025-05-28 14:47:17','2025-05-28 14:47:17'),(20,'App\\Models\\Employee',1,'employee-token','90788aadf412cbfb65573b3a4b850023a77e076ec4ecdf627ce0d4d7bd199c62','[\"*\"]',NULL,NULL,'2025-05-28 16:18:06','2025-05-28 16:18:06'),(21,'App\\Models\\Employee',1,'employee-token','abfba6be187170074bec8848e6590e811c4a964db249f94f785359c1772578e0','[\"*\"]',NULL,NULL,'2025-05-28 16:22:16','2025-05-28 16:22:16'),(22,'App\\Models\\Employee',1,'employee-token','e9903002642eb1338ced83144160f5f7709783560ccd4665ad9f738319a46643','[\"*\"]',NULL,NULL,'2025-05-28 16:23:22','2025-05-28 16:23:22'),(23,'App\\Models\\Employee',1,'employee-token','8894313a93b8278ce1c1369258e56fc798bcbe85eaa2b5d49e64944c072bcfa2','[\"*\"]','2025-05-28 20:20:38',NULL,'2025-05-28 17:27:15','2025-05-28 20:20:38'),(24,'App\\Models\\Employee',1,'employee-token','032dc666e66a3f37f08acb942413fa098a4f0bc5bfa8d8e6ee3985004c3aebe4','[\"*\"]','2025-05-29 13:19:21',NULL,'2025-05-29 12:13:59','2025-05-29 13:19:21'),(25,'App\\Models\\Employee',1,'employee-token','e5617a386913917076a7f1d03b5f7fb3a2890016ac38ca744cd2ba0db1b7b82c','[\"*\"]','2025-05-29 14:00:16',NULL,'2025-05-29 13:28:27','2025-05-29 14:00:16'),(26,'App\\Models\\Employee',1,'employee-token','342d4815e405b1aa34f76940d3dec29fc83f120377c935073895ec50718dbcb8','[\"*\"]','2025-05-29 15:00:38',NULL,'2025-05-29 14:01:11','2025-05-29 15:00:38'),(27,'App\\Models\\Employee',1,'employee-token','fc3ea875f9ea1ed63e1b2be3ae072ff35f9e3261c7faa9ac6b8c680c0ea88f18','[\"*\"]','2025-05-29 15:28:11',NULL,'2025-05-29 15:22:45','2025-05-29 15:28:11'),(28,'App\\Models\\Employee',1,'employee-token','3467999429b9a162561fea433718b37d04745d505b11fea3d872036f0ce2903a','[\"*\"]','2025-05-29 15:56:45',NULL,'2025-05-29 15:40:35','2025-05-29 15:56:45'),(29,'App\\Models\\Employee',1,'employee-token','101819a76b47956706cad9423b48c09d83fd5bb98832a45e68e46f1c6da2e082','[\"*\"]','2025-05-29 17:10:16',NULL,'2025-05-29 15:57:33','2025-05-29 17:10:16'),(30,'App\\Models\\Employee',1,'employee-token','ea4453b6132f623b998138b32f683e47f54d160cc6455ea053e95ba71aaf8d9b','[\"*\"]','2025-05-29 20:42:31',NULL,'2025-05-29 20:42:20','2025-05-29 20:42:31'),(31,'App\\Models\\Employee',1,'employee-token','da43e583f14c2951dcd41a1b40f4e3234eebac4127961c483f4a99aecafd7bbb','[\"*\"]','2025-05-29 20:49:30',NULL,'2025-05-29 20:43:12','2025-05-29 20:49:30'),(32,'App\\Models\\User',6,'api-token','493b33e6d6e8276a0d4c91005341a2612ed09ca6a6e8d3edb10f0e80af242f40','[\"*\"]','2025-06-02 16:14:25',NULL,'2025-06-01 13:03:49','2025-06-02 16:14:25'),(33,'App\\Models\\User',6,'api-token','c284cf3541b6a55a3824f0227dfd2388c0eba8def8f65d2a2f5d32d253e17498','[\"*\"]',NULL,NULL,'2025-06-01 16:35:58','2025-06-01 16:35:58'),(34,'App\\Models\\User',6,'api-token','f30b4012ac1fdce5a853858a00d6948ae51d2d27d4581c08585b7dd2f6989529','[\"*\"]','2025-06-02 14:39:41',NULL,'2025-06-02 14:37:59','2025-06-02 14:39:41'),(35,'App\\Models\\User',6,'api-token','87f8f8211470b6ffc980b0e5f044fa5a70ade6a7972dc87aafdda1aaddfd067f','[\"*\"]','2025-06-02 15:20:33',NULL,'2025-06-02 15:08:32','2025-06-02 15:20:33'),(36,'App\\Models\\User',6,'api-token','6ac0bbd77807f3d13cb62f486657f587a379d952adc222eb0056f00a11ec6ccd','[\"*\"]','2025-06-02 16:26:45',NULL,'2025-06-02 16:16:49','2025-06-02 16:26:45'),(37,'App\\Models\\User',6,'api-token','7d986038aae2fb0502e97954f6b5a510795ac8e1677194795a08e92fe1730648','[\"*\"]','2025-06-02 16:49:55',NULL,'2025-06-02 16:49:46','2025-06-02 16:49:55'),(38,'App\\Models\\Employee',1,'employee-token','9e830e764a8dc949313a0f5dba756f5be3bc00951692277cc789394c59e059df','[\"*\"]',NULL,NULL,'2025-06-03 11:56:48','2025-06-03 11:56:48'),(39,'App\\Models\\Employee',1,'employee-token','7fc58d0c6dcbfd6404be3e31c4a7723b5b381102e7f5be731292415ff07cba2d','[\"*\"]',NULL,NULL,'2025-06-03 12:33:16','2025-06-03 12:33:16'),(40,'App\\Models\\Employee',1,'employee-token','87c95fd719240bc72b73b1f49d4093f8c7bbcb0d4dfc9cb3c8a87b1a53ec87c1','[\"*\"]','2025-06-03 15:39:42',NULL,'2025-06-03 12:46:28','2025-06-03 15:39:42'),(41,'App\\Models\\User',6,'api-token','5584c034d91e6d18c462e1165e6f2c8902d924762662b6b997200bf85d26ba61','[\"*\"]','2025-06-03 13:46:08',NULL,'2025-06-03 13:12:03','2025-06-03 13:46:08');
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `procedure_report`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `procedure_report` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `report_id` bigint unsigned NOT NULL,
  `procedure_id` bigint unsigned NOT NULL,
  `employee_id` bigint unsigned DEFAULT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `procedure_report_report_id_foreign` (`report_id`),
  KEY `procedure_report_procedure_id_foreign` (`procedure_id`),
  KEY `procedure_report_employee_id_foreign` (`employee_id`),
  CONSTRAINT `procedure_report_employee_id_foreign` FOREIGN KEY (`employee_id`) REFERENCES `employees` (`id`) ON DELETE SET NULL,
  CONSTRAINT `procedure_report_procedure_id_foreign` FOREIGN KEY (`procedure_id`) REFERENCES `procedures` (`id`) ON DELETE CASCADE,
  CONSTRAINT `procedure_report_report_id_foreign` FOREIGN KEY (`report_id`) REFERENCES `reports` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `procedure_report` WRITE;
/*!40000 ALTER TABLE `procedure_report` DISABLE KEYS */;
INSERT INTO `procedure_report` VALUES (1,1,3,NULL,'تم حل المشكله بكامل تفاصيلها','2025-05-26 11:19:04','2025-05-26 11:19:04'),(2,7,1,NULL,'تم تعيين فريق','2025-05-29 14:32:04','2025-05-29 14:32:04');
/*!40000 ALTER TABLE `procedure_report` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `procedures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `procedures` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `procedures` WRITE;
/*!40000 ALTER TABLE `procedures` DISABLE KEYS */;
INSERT INTO `procedures` VALUES (1,'تحويل الي الجهة المختصة','تحويل الي الجهة المختصة','2025-05-25 20:31:01','2025-05-25 20:31:01'),(2,'جاري التحقيق','جاري التحقيق','2025-05-25 20:31:01','2025-05-25 20:31:01'),(3,'تم إتخاذ الإجراء المطلوب','تم إتخاذ الإجراء المطلوب','2025-05-25 20:31:01','2025-05-25 20:31:01'),(4,'مرفوضة مع سبب','مرفوضة مع سبب','2025-05-25 20:31:01','2025-05-25 20:31:01');
/*!40000 ALTER TABLE `procedures` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `report_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `report_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `report_types_name_unique` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `report_types` WRITE;
/*!40000 ALTER TABLE `report_types` DISABLE KEYS */;
INSERT INTO `report_types` VALUES (1,'الإبلاغ عن جريمة','الإبلاغ عن جريمة','2025-05-25 20:30:12','2025-05-25 20:30:12'),(2,'مشكلة في الطريق','مشكلة في الطريق','2025-05-25 20:30:12','2025-05-25 20:30:12'),(3,'الاإبلاغ عن فساد','الاإبلاغ عن فساد','2025-05-25 20:30:12','2025-05-25 20:30:12');
/*!40000 ALTER TABLE `report_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `reports`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `reports` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `report_no` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `report_type_id` bigint unsigned NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ll` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lg` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `file_path` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `procedure_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `attachment_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `reports_report_no_unique` (`report_no`),
  KEY `reports_user_id_foreign` (`user_id`),
  KEY `reports_report_type_id_foreign` (`report_type_id`),
  KEY `reports_procedure_id_foreign` (`procedure_id`),
  KEY `reports_attachment_id_foreign` (`attachment_id`),
  CONSTRAINT `reports_attachment_id_foreign` FOREIGN KEY (`attachment_id`) REFERENCES `attachments` (`id`) ON DELETE SET NULL,
  CONSTRAINT `reports_procedure_id_foreign` FOREIGN KEY (`procedure_id`) REFERENCES `procedures` (`id`) ON DELETE SET NULL,
  CONSTRAINT `reports_report_type_id_foreign` FOREIGN KEY (`report_type_id`) REFERENCES `report_types` (`id`) ON DELETE CASCADE,
  CONSTRAINT `reports_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `reports` WRITE;
/*!40000 ALTER TABLE `reports` DISABLE KEYS */;
INSERT INTO `reports` VALUES (1,'REP-HKUOCRX3',2,2,'هناك حفرة كبيرة جدا في الطريق','16 ش المعز لدين الله','20.589','20.589','reports/EU5pJFOE50BtKA2UhmKY9eIbmRmclqNDPvwbTFrK.pdf',3,'2025-05-25 20:44:19','2025-05-25 20:44:19',NULL),(2,'REP-KVL2B1FC',2,1,'هناك جريمة قتل','16 ش المعز لدين الله الحسين','20.589','20.589','reports/bU273OZegPX3NRK9WITlu2eeRRhNzSRGeMQwdo52.pdf',NULL,'2025-05-25 20:46:35','2025-05-25 20:46:35',NULL),(7,'REP-RDEDOLRS',6,1,'هناك محاوله تطفل','16 ش المعز لدين الله الحسين','20.589','20.589',NULL,1,'2025-05-28 15:44:39','2025-05-29 14:32:04',1),(8,'REP-DUDKEJYV',6,1,'هناك محاوله تطفل','16 ش المعز لدين الله الحسين','20.589','20.589',NULL,NULL,'2025-05-28 17:40:30','2025-05-28 17:40:30',NULL),(9,'REP-ZK0FSSFZ',6,1,'test',NULL,'37.4219983','-122.084',NULL,NULL,'2025-05-28 18:08:09','2025-05-28 18:08:09',NULL),(10,'REP-VZ6J2KRD',6,1,'test',NULL,'37.4219983','-122.084',NULL,NULL,'2025-05-28 18:08:57','2025-05-28 18:08:57',NULL),(11,'REP-BXQEH6MG',6,1,'هناك محاوله تطفل','16 ش المعز لدين الله الحسين','20.589','20.589',NULL,NULL,'2025-06-01 11:49:58','2025-06-01 11:49:58',NULL),(12,'REP-QDKNB6NX',6,3,'teat','X89F+FMR, , معادي السرايات الغربية, محافظة القاهرة‬ 4064160, مصر','29.9682945','31.3243104',NULL,NULL,'2025-06-01 16:18:22','2025-06-01 16:18:22',NULL),(13,'REP-KRK7ZPYK',6,1,'test',', معادي السرايات الغربية, محافظة القاهرة‬, مصر','29.9683248','31.3243672',NULL,NULL,'2025-06-01 16:21:01','2025-06-01 16:21:01',NULL),(14,'REP-FB0HGQVO',6,2,'accident 😞😞😞😞',', معادي السرايات الغربية, محافظة القاهرة‬, مصر','29.9683179','31.3243498',NULL,NULL,'2025-06-02 16:26:44','2025-06-02 16:26:44',NULL);
/*!40000 ALTER TABLE `reports` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `national_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `otp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otp_expires_at` timestamp NULL DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_national_id_unique` (`national_id`),
  UNIQUE KEY `users_phone_unique` (`phone`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'Super Admin','12345678901234','01157861819',NULL,NULL,'NCqDIgXpV6','2025-05-25 19:42:41','2025-05-28 11:01:43'),(2,'Test User 1','29305200102562','01063153631',NULL,NULL,NULL,'2025-05-25 19:45:46','2025-05-25 20:41:03'),(6,NULL,'11111111111111','+201000255723',NULL,NULL,NULL,'2025-05-28 12:43:44','2025-06-03 13:12:03');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

