<?php

namespace App\Http\Resources;

use App\Exceptions\BalaghatException;
use App\Models\Employee;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProcedureResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $employee = Employee::find($this->pivot?->employee_id);
        return [
            'procedure_id' => $this->pivot?->procedure_id ?? '',
            'name' => $this->name,
            'notes' => $this->pivot?->notes ?? '',
            'employee_id' => $employee?->id ?? '',
            'employee_name' => $employee?->name ?? '',
            'created_at' => $this->pivot->created_at ?? null,
            'updated_at' => $this->pivot->updated_at ?? null,
        ];
    }
}
