<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ReportResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $user = $this->whenLoaded('user');
        return [
            'id' => $this->id,
            'report_no' => $this->report_no,
            'user' => $user?->name,
            'user_id' => $user?->id,
            'type' => $this->type->name,
            'type_id' => $this->type->id,
            'description' => $this->description,
            'll' => $this->ll,
            'lg' => $this->lg,
            'location' => $this->location,
            'status' => $this->status?->name ?? '',
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'procedures' => ProcedureResource::collection($this->procedures),
            'attachments' => $this->attachments,
        ];
    }
}
