<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Procedure extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'description',
    ];

    public function reports()
    {
        return $this->belongsToMany(Report::class, 'procedure_report')
            ->withPivot('notes', 'employee_id')
            ->withTimestamps()
            ->using(ProcedureReport::class);
    }
}
