<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ProcedureReport extends Model
{
    use HasFactory;
    protected $table = 'procedure_report';
    protected $fillable = [
        'employee_id',
        'report_id',
        'procedure_id',
        'notes',
    ];
    public function report()
    {
        return $this->belongsTo(Report::class);
    }
    public function procedure()
    {
        return $this->belongsTo(Procedure::class);
    }
    public function employee()
    {
        return $this->belongsTo(Employee::class,'employee_id');
    }
}
