<?php

use App\Http\Controllers\AttachmentController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\ProcedureController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ReportTypeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/


Route::get('/test', function () {
    return response()->json(['message' => 'API is working']);
});

// Auth API
Route::post('/employee/login', [AuthController::class, 'loginEmployees']);
Route::post('/send-otp', [AuthController::class, 'sendOtp']);
Route::post('/verify-otp', [AuthController::class, 'verifyOtp']);
Route::post('/logout', [AuthController::class, 'logout']);


// All Reports Apis
Route::get('/all-reports', [ReportController::class, 'getAllReports']); // Pagination
Route::get('/reports/{report}', [ReportController::class, 'show']);

// global apis
Route::get('/report-types', [ReportTypeController::class, 'index']);
Route::get('/procedures', [ProcedureController::class, 'index']);


// Upload attachments
Route::post('/uploads', [AttachmentController::class, 'upload']);



